package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

/**
 * Describes a repository hook and its state for a specific scope.
 */
public interface RepositoryHook {

    /**
     * @return the associated details of this repository hook
     */
    @Nonnull
    RepositoryHookDetails getDetails();

    /**
     * @return the scope at which the repository hook was configured
     * @since 5.2
     */
    @Nonnull
    Scope getScope();

    /**
     * @return {@code true} if this hook has been enabled, {@code false} otherwise
     */
    boolean isEnabled();

    /**
     * @return {@code true} if settings have been previously stored for this hook and {@link #getScope() scope}
     *         {@code false} otherwise.
     */
    boolean isConfigured();
}
