package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a repository has been successfully updated.
 * <p>
 * When this event is raised, the repository's persisted state has been updated and committed, so
 * {@link #getRepository()} matches the {@link #getNewValue() new values}.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.updated")
public class RepositoryModifiedEvent extends AbstractRepositoryModificationEvent {

    public RepositoryModifiedEvent(@Nonnull Object source, @Nonnull Repository oldValue, @Nonnull Repository newValue) {
        super(source, newValue, oldValue, newValue);
    }
}
