package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when an SCM client clones a repository.
 * <p>
 * Differentiating an incremental {@link RepositoryPullEvent pull} from a full clone is left to the SCM implementation.
 * Some SCMs may not raise this event.
 */
@AsynchronousPreferred
@EventName("stash.repository.cloned")
public class RepositoryCloneEvent extends RepositoryPullEvent {

    public RepositoryCloneEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
