package com.atlassian.bitbucket.event.hook;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Fired when a repository hook is deleted
 *
 * @since 5.15
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.hook.deleted")
public class RepositoryHookDeletedEvent extends RepositoryHookEvent {

    /**
     * @param source            the object on which the Event initially occurred
     * @param repositoryHookKey the key of the repository hook
     * @param scope             scope that the hook event was created for
     */
    public RepositoryHookDeletedEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull String repositoryHookKey) {
        super(source, repositoryHookKey, scope);
    }
}
