package com.atlassian.bitbucket.event.commit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a comment is added in a commit discussion.
 * <p>
 * This does not include replies, which raise a {@link CommitDiscussionCommentRepliedEvent}.
 */
@AsynchronousPreferred
@EventName("stash.commit.comment.added")
public class CommitDiscussionCommentAddedEvent extends CommitDiscussionCommentEvent {

    /**
     * @param source     the component raising the event
     * @param discussion the commit discussion this comment relates to
     * @param comment    the comment
     * @since 6.6
     */
    public CommitDiscussionCommentAddedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                             @Nonnull Comment comment) {
        super(source, discussion, comment, null, CommentAction.ADDED);
    }
}
