package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A specialization of {@link AuthenticationException} that should be thrown when an existing authentication has
 * expired.
 */
public class ExpiredAuthenticationException extends AuthenticationException {

    public ExpiredAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public ExpiredAuthenticationException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
