package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.net.URI;

/**
 * Indicates that authentication is required with {@code applicationName} and provides a {@code URI} to authenticate
 */
public class AuthenticationRequiredException extends ServiceException {

    private URI authenticationUri;
    private String applicationName;

    public AuthenticationRequiredException(@Nonnull KeyedMessage message, URI authenticationUri, String applicationName) {
        super(message);
        this.authenticationUri = authenticationUri;
        this.applicationName = applicationName;
    }

    public AuthenticationRequiredException(@Nonnull KeyedMessage message, @Nullable Throwable cause, URI authenticationUri, String applicationName) {
        super(message, cause);
        this.authenticationUri = authenticationUri;
        this.applicationName = applicationName;
    }

    public URI getAuthenticationUri() {
        return authenticationUri;
    }

    public String getApplicationName() {
        return applicationName;
    }
}
