package com.atlassian.bitbucket.watcher;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;

/**
 * A service for interacting with {@link Watcher watchers}
 *
 * @since 5.10
 */
public interface WatcherService {

    /**
     * Checks if a {@link Watcher watcher} exists that matches the provided request
     *
     * @param request a request describing the watcher to match
     * @return {@code true} if a watcher exists that matches the provided request, {@code false} otherwise
     */
    boolean isWatching(@Nonnull IsWatchingRequest request);

    /**
     * Search for {@link Watcher watcher} entities matching the criteria in the provided
     * {@link WatcherSearchRequest request}
     *
     * @param request a request describing the watchers to search for
     * @param pageRequest the page request
     * @return a page of watchers matching the criteria in the provided request
     */
    @Nonnull
    Page<Watcher> search(@Nonnull WatcherSearchRequest request, @Nonnull PageRequest pageRequest);

    /**
     * Removes a user as a watcher of the given {@link UnwatchRequest#getWatchable() watchable}.
     * If the {@link UnwatchRequest#getUser() user} is not provided the authenticated user is used.
     * If the user is not watching the watchable, this method will have no effect and return {@code false}.
     *
     * @param request a request describing the watcher to delete
     * @return {@code true} if the watcher existed and was removed, {@code false} otherwise
     */
    boolean unwatch(@Nonnull UnwatchRequest request);

    /**
     * Adds a new user as a {@link Watcher watcher}. If the {@link WatchRequest#getUser() user} is not provided,
     * the authenticated user is used. If the user is already watching the {@link Watchable watchable} this method
     * will simply return the corresponding {@link Watcher watcher} instance.
     *
     * @param request a request describing the watcher to create
     * @return the created watcher
     */
    @Nonnull
    Watcher watch(@Nonnull WatchRequest request);
}
