package com.atlassian.bitbucket.watcher;

import javax.annotation.Nonnull;

/**
 * @since 5.10
 */
public class IsWatchingRequest extends AbstractWatcherRequest {

    private IsWatchingRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, IsWatchingRequest> {

        public Builder(@Nonnull Watchable watchable) {
            super(watchable);
        }

        @Nonnull
        @Override
        public IsWatchingRequest build() {
            return new IsWatchingRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
