package com.atlassian.bitbucket.validation.annotation;

import org.hibernate.validator.constraints.Length;

import javax.validation.Constraint;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.lang.annotation.*;

/**
 * Validate that the string is not empty and below a certain size,
 * and report any violation as a single message.
 */
@Constraint(validatedBy = {})
@Documented
@Length
@NotBlank
@Pattern(regexp = ".*", flags = Pattern.Flag.DOTALL)
@Repeatable(RequiredStrings.class)
@ReportAsSingleViolation
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD})
public @interface RequiredString {

    Class<?>[] groups() default {};

    String message() default "{com.atlassian.bitbucket.validation.required.string.message}";

    @OverridesAttribute(constraint = Length.class, name = "min")
    int minimumSize() default 1;

    Class<? extends Payload>[] payload() default {};

    @OverridesAttribute(constraint = Pattern.class, name = "regexp")
    String regexp() default ".*";

    @OverridesAttribute(constraint = Length.class, name = "max")
    int size() default 255;
}