package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.IntValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * Validate a number is a valid integer.
 *
 * <p>{@code null} are considered valid to follow the JSR-303 convention:
 * ex: {@code @Min}, {@code @Max}, {@code @Email}, {@code @SafeHtml}, etc. .</p>
 *
 * @see javax.validation.constraints.Digits
 */
@Constraint(validatedBy = {IntValidator.class})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD})
public @interface Int {

    String message() default "{com.atlassian.bitbucket.validation.required.int.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
