package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArgumentValidationException extends ServiceException {

    private static final long serialVersionUID = 1;

    public ArgumentValidationException(@Nonnull KeyedMessage message) {
        super(message);
    }

    /**
     * @param message a message explaining the validation error
     * @param cause   a related exception which occurred during validation
     * @since 6.0
     */
    public ArgumentValidationException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
