package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Specialisation of {@link NoSuchEntityException} thrown to indicate the named group does not exist.
 */
public class NoSuchGroupException extends NoSuchEntityException {

    private final String groupName;

    public NoSuchGroupException(@Nonnull KeyedMessage message, @Nonnull String groupName) {
        super(message);

        this.groupName = requireNonNull(groupName, "groupName");
    }

    /**
     * Retrieves the name of the group which was requested but not found.
     *
     * @return the group name
     */
    @Nonnull
    public String getGroupName() {
        return groupName;
    }
}
