package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

public abstract class AbstractApplicationUserVisitor<T> implements ApplicationUserVisitor<T> {

    @Override
    public T visit(@Nonnull DetailedUser user) {
        return defaultValue(user);
    }

    @Override
    public T visit(@Nonnull ServiceUser user) {
        return defaultValue(user);
    }

    @Override
    public T visit(@Nonnull ApplicationUser user) {
        return defaultValue(user);
    }

    /**
     * Convenience method that allows implementors to provide a single fallback return value
     *
     * @param user the user
     * @return the default value
     * @since 4.3
     */
    protected T defaultValue(ApplicationUser user) {
        return null;
    }
}
