package com.atlassian.bitbucket.server;

import javax.annotation.Nonnull;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * Simple implementation of the {@link Feature} interface
 *
 * @since 4.1
 */
public class SimpleFeature implements Feature {

    private final boolean dataCenter;
    private final String key;

    private SimpleFeature(Builder builder) {
        this.dataCenter = builder.dataCenter;
        this.key = builder.key;
    }

    @Nonnull
    @Override
    public String getKey() {
        return key;
    }

    @Override
    public boolean isDataCenter() {
        return dataCenter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SimpleFeature that = (SimpleFeature) o;
        return this.dataCenter == that.dataCenter &&
                this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
      return Objects.hash(dataCenter, key);
    }

    public static class Builder {

        private final String key;
        private boolean dataCenter;

        public Builder(@Nonnull String key) {
            this.key = requireNonNull(key, "key");
        }

        @Nonnull
        public SimpleFeature build() {
            return new SimpleFeature(this);
        }

        @Nonnull
        public Builder dataCenter(boolean value) {
            this.dataCenter = value;
            return this;
        }
    }
}
