package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Summarizes the results of a bulk signed commits command.
 *
 * @since 5.1
 */
public class SignedObjectsSummary extends AbstractSummary {

    private SignedObjectsSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, SignedObjectsSummary> {

        /**
         * Creates and initializes a new builder by copying details from the provided summary.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public SignedObjectsSummary build() {
            return new SignedObjectsSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
