package com.atlassian.bitbucket.scm.ref;

import javax.annotation.Nonnull;

public class CreateTagCommandParameters extends AbstractCreateRefCommandParameters {

    protected CreateTagCommandParameters(AbstractCreateTagBuilder builder) {
        super(builder);
    }

    public static class Builder extends AbstractCreateTagBuilder<Builder> {

        @Nonnull
        public CreateTagCommandParameters build() {
            validate();

            return new CreateTagCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }

    public abstract static class AbstractCreateTagBuilder<B extends AbstractCreateTagBuilder<B>>
            extends AbstractCreateRefBuilder<B> {
    }
}