package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Summarizes the results of {@link BulkCommitCallback streaming bulk commits}.
 *
 * @since 5.8
 */
public class BulkCommitSummary extends AbstractSummary {

    private BulkCommitSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, BulkCommitSummary> {

        /**
         * Creates and initializes a new builder by copying details from the provided summary.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public BulkCommitSummary build() {
            return new BulkCommitSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
