package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

/**
 * @since 7.14
 * @see ScmCommandFactory#resolveCommits(ResolveCommitsCommandParameters)
 */
public class ResolveCommitsCommandParameters {

    private final Set<String> revisions;

    private ResolveCommitsCommandParameters(Builder builder) {
        revisions = builder.revisions.build();
    }

    /**
     * @return the revisions (anything that can be resolved to a commit ID, including branch and tag names) to resolve.
     */
    @Nonnull
    public Set<String> getRevisions() {
        return revisions;
    }

    public static class Builder extends BuilderSupport {

        private final ImmutableSet.Builder<String> revisions;

        public Builder() {
            revisions = ImmutableSet.builder();
        }

        @Nonnull
        public ResolveCommitsCommandParameters build() {
            return new ResolveCommitsCommandParameters(this);
        }

        @Nonnull
        public Builder revisions(@Nullable String value, @Nullable String... moreValues) {
            addIf(Objects::nonNull, revisions, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder revisions(@Nullable Iterable<String> values) {
            addIf(Objects::nonNull, revisions, values);
            return this;
        }
    }
}
