package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * Parameters for requesting a {@link ScmCommandFactory#repositorySize repository's size}.
 *
 * @see ScmCommandFactory#repositorySize(Repository, RepositorySizeCommandParameters)
 * @since 7.14
 */
public class RepositorySizeCommandParameters extends AbstractCommandParameters {

    private RepositorySizeCommandParameters(@Nonnull Builder ignored) {
    }

    public static class Builder {

        @Nonnull
        public RepositorySizeCommandParameters build() {
            return new RepositorySizeCommandParameters(this);
        }

    }
}