package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * @since 7.11
 */
public class PushSummary extends AbstractSummary {

    private PushSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, PushSummary> {

        /**
         * Creates and initializes a new builder using details from the provided {@link AbstractSummary summary}.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public PushSummary build() {
            return new PushSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
