package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Summarizes a {@link Command command} that has been run.
 * <p>
 * As of 2.10 this summary is very minimal. It is a full state object with its own {@link CommandSummary.Builder
 * builder} to simplify the process of adding additional summary data in subsequent releases.
 */
public class CommandSummary extends AbstractSummary {

    private CommandSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, CommandSummary> {

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the command result for the summary
         */
        public Builder(CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public CommandSummary build() {
            return new CommandSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
