package com.atlassian.bitbucket.scm;

import javax.annotation.Nullable;

/**
 * Describes a handler which processes the standard output stream from a {@link Command} and, optionally, produces
 * some object {@code T} from it.
 * <p>
 * For commands which produce no interesting output, or for output handlers which process output in a way that does not
 * result in an object graph (for example, handlers that directly pipe data through some sort of callback), {@code T}
 * should be specialised as {@code Void} and {@link #getOutput()} should return {@code null}.
 *
 * @param <T> the object type the output handler will produce when the command is run
 * @see CommandAware
 */
public interface CommandOutputHandler<T> extends CommandOutputHandlerSupport {

    /**
     * Retrieves the processed output, if any.
     * <p>
     * Output handler implementations which are <i>expected or required</i> to produce output are encouraged to defer
     * throwing any exception indicating no output was produced until this method is called, rather than throwing the
     * exception during {@link #process(java.io.InputStream) processing}.
     *
     * @return the processed output, which may be {@code null} if the command produced no interesting output
     */
    @Nullable
    T getOutput();
}
