package com.atlassian.bitbucket.scm;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

/**
 * Describes a {@link #getCommitId commit}:{@link #getPath path} pair to calculate blame for. Blame calculations
 * <i>start</i> at the specified {@link #getCommitId commit}, and work backward through history to determine the
 * most recent commit to modify each line in the requested file.
 */
public class BlameCommandParameters extends AbstractCommitCommandParameters {

    private BlameCommandParameters(Builder builder) {
        super(builder);

        if (StringUtils.isBlank(getCommitId())) {
            throw new IllegalStateException("A starting commit ID is required to calculate blame");
        }
        if (StringUtils.isBlank(getPath())) {
            throw new IllegalStateException("A path is required to calculate blame");
        }
    }

    /**
     * @return the path to calculate blame for
     * @since 4.6
     */
    @Nonnull
    @Override
    public String getPath() {
        //The presence of a path is checked in the constructor, and results in an IllegalStateException
        //if it's missing.
        //noinspection ConstantConditions
        return super.getPath();
    }

    /**
     * @return {@code true}
     * @since 4.6
     */
    @Override
    public boolean hasPath() {
        return true;
    }

    public static class Builder extends AbstractCommitParametersBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public BlameCommandParameters build() {
            return new BlameCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
