package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * An SCM available for creating new {@link Repository repositories}.
 */
public interface AvailableScm {

    /**
     * @return the SCM's identifier, which is guaranteed to be unique across all available SCMs
     */
    @Nonnull
    String getId();

    /**
     * @return the SCM's human-readable name
     */
    @Nonnull
    String getName();
}
