package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.AbstractRepositoryRefsRequest;
import com.atlassian.bitbucket.repository.RefOrder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

public abstract class AbstractRefsCommandParameters extends AbstractCommandParameters {

    private final String filterText;
    private final RefOrder order;

    /**
     * @param builder the builder to extract parameters from
     * @since 5.1
     */
    protected AbstractRefsCommandParameters(AbstractBuilder<?> builder) {
        filterText = builder.filterText;
        order = builder.order;
    }

    @Nullable
    public String getFilterText() {
        return filterText;
    }

    @Nullable
    public RefOrder getOrder() {
        return order;
    }

    public abstract static class AbstractBuilder<B extends AbstractBuilder<B>> {

        private String filterText;
        private RefOrder order;

        public AbstractBuilder() {
        }

        /**
         * @param request the request to copy parameters from
         * @since 5.1
         */
        public AbstractBuilder(@Nonnull AbstractRepositoryRefsRequest request) {
            requireNonNull(request, "request");

            filterText(request.getFilterText())
                    .order(request.getOrder());
        }

        @Nonnull
        public B filterText(@Nullable String value) {
            filterText = value;

            return self();
        }

        @Nonnull
        public B order(@Nullable RefOrder value) {
            order = value;

            return self();
        }

        @Nonnull
        protected abstract B self();
    }
}
