package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Occurs when a repository is offline, i.e., when the node on which a repository is present becomes unreachable.
 *
 * @since 7.12
 */
public class RepositoryOfflineException extends IllegalRepositoryStateException {

    private final KeyedMessage detailedMessage;

    /**
     * @param message         a short summary message, must not be {@code null}
     * @param detailedMessage the more detailed message, must not be {@code null}
     * @since 7.15
     */
    public RepositoryOfflineException(@Nonnull KeyedMessage message, @Nonnull KeyedMessage detailedMessage) {
        this(message, detailedMessage, null);
    }

    /**
     * @param message         a short summary message, must not be {@code null}
     * @param detailedMessage the more detailed message, must not be {@code null}
     * @param cause           the cause of the failure, which may be {@code null} for top-level failures
     * @since 7.18
     */
    public RepositoryOfflineException(@Nonnull KeyedMessage message, @Nonnull KeyedMessage detailedMessage,
                                      @Nullable Throwable cause) {
        super(message, cause);
        this.detailedMessage = requireNonNull(detailedMessage, "detailedMessage");
    }

    /**
     * Returns the detailed message for this exception. 
     *
     * @return the {@link KeyedMessage detailed message}
     * @since 7.15
     */
    @Nonnull
    public KeyedMessage getDetailedMessage() {
        return detailedMessage;
    }
}
