package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Locale;

import static java.util.Objects.requireNonNull;

/**
 * A flag used when searching for and/or archived repositories.
 *
 * @since 8.0
 */
public enum
    
RepositoryArchiveFilter {

    ACTIVE(false),
    ALL(null),
    ARCHIVED(true);

    private final Boolean value;

    RepositoryArchiveFilter(Boolean value) {
        this.value = value;
    }

    @Nonnull
    public static RepositoryArchiveFilter fromString(@Nonnull String stringValue) {
        requireNonNull(stringValue, "stringValue");

        return valueOf(stringValue.toUpperCase(Locale.ROOT));
    }

    @Nullable
    public Boolean flag() {
        return value;
    }
}
