package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * Represents the different types of ref changes.
 */
public enum RefChangeType {

    ADD(1),
    DELETE(2),
    UPDATE(3);

    private final int id;

    private RefChangeType(int id) {
        this.id = id;
    }

    /**
     * @param id the {@link #getId() unique identifier} for the type (<i>not</i> its {@code ordinal()})
     * @return the matching type
     * @throws IllegalArgumentException if the specified ID does not match a type
     */
    @Nonnull
    public static RefChangeType fromId(int id) {
        for (RefChangeType value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No RefChangeType is associated with ID [" + id + "]");
    }

    /**
     * @return a unique identifier for this type which will never change
     */
    public int getId() {
        return id;
    }
}
