package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate an operation could not be completed because the {@link Repository repository} was not in the
 * expected {@link Repository.State state}. For example, attempting to retry creating a repository might throw this
 * exception if the repository was already created successfully.
 */
public class IllegalRepositoryStateException extends IllegalEntityStateException {

    public IllegalRepositoryStateException(@Nonnull KeyedMessage message) {
        super(message);
    }

    /**
     * @param message a message describing the failure
     * @param cause   the cause of the failure, which may be {@code null} for top-level failures
     * @since 7.18
     */
    public IllegalRepositoryStateException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
