package com.atlassian.bitbucket.pull.reviewer;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Set;

/**
 * Represents a reviewer group
 *
 * @since 7.13
 */
public interface ReviewerGroup {

    /**
     * @return the description of the reviewer group
     */
    @Nullable
    String getDescription();

    /**
     * @return the unique ID of the reviewer group
     */
    long getId();

    /**
     * @return the name of the reviewer group, which is unique for a given {@link Scope}
     */
    @Nonnull
    String getName();

    /**
     * @return the scope the reviewer group belongs to
     */
    @Nonnull
    Scope getScope();

    /**
     * @return the reviewers in the group
     */
    @Nonnull
    Set<ApplicationUser> getUsers();
}