package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.commit.Commit;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Lists the commits added or removed by a {@link PullRequestRescopeActivity pull request rescope}.
 *
 * @see PullRequestRescopeActivity
 * @see PullRequestRescopeActivity#getAdded()
 * @see PullRequestRescopeActivity#getRemoved()
 */
public interface RescopeDetails {

    /**
     * @return a list of 0 or more commits added or removed by the rescope
     */
    @Nonnull
    List<Commit> getCommits();

    int getTotal();
}
