package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

/**
 * Enumerates the possible {@link PullRequest#getState() states} a pull request can be in.
 *
 * @see PullRequest#getState()
 */
public enum PullRequestState {

    /**
     * The {@link PullRequest pull request} has been declined.
     */
    DECLINED(2),
    /**
     * The {@link PullRequest pull request} has been accepted and merged.
     */
    MERGED(1),
    /**
     * The {@link PullRequest pull request} is open.
     */
    OPEN(0);

    private final int id;

    PullRequestState(int id) {
        this.id = id;
    }

    @Nonnull
    public static PullRequestState fromId(int id) {
        for (PullRequestState value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No PullRequestState is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}
