package com.atlassian.bitbucket.project;

/**
 * Enumerates available {@link Project project} types.
 */
public enum ProjectType {

    /**
     * Type for a {@link Project simple project} instance.
     */
    NORMAL(0),
    /**
     * Type for a {@link PersonalProject personal project} instance.
     */
    PERSONAL(1);
    
    private final int id;

    ProjectType(int id) {
        this.id = id;
    }

    @SuppressWarnings("unused") //Used by Hibernate
    public static ProjectType fromId(int id) {
        for (ProjectType value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No ProjectType is available for ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}