package com.atlassian.bitbucket.permission;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

/**
 * Defines an association between a {@link ApplicationUser} and a {@link Permission} which has been granted to them.
 *
 * @see PermittedGroup
 */
public interface PermittedUser {

    /**
     * Retrieves the permission which has been granted to the user.
     *
     * @return the granted permission
     */
    @Nonnull
    Permission getPermission();

    /**
     * Retrieves the user to which the permission has been granted.
     * <p>
     * Note, the user may not be {@link ApplicationUser#isActive() active}
     *
     * @return the permitted user
     */
    @Nonnull
    ApplicationUser getUser();
}
