package com.atlassian.bitbucket.migration.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when migrating repositories from Bitbucket DC to Mesh has been started.
 *
 * @since 8.0
 */
@AsynchronousPreferred
@EventName("stash.migration.mesh.start")
public class MeshMigrationStartedEvent extends AbstractInstanceMigrationEvent {

    public MeshMigrationStartedEvent(@Nonnull Object source, @Nonnull Job job) {
        super(source, job);
    }
}