package com.atlassian.bitbucket.migration.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;

import javax.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;

/**
 * Abstract superclass for Data Center Migration events.
 *
 * @since 5.13
 */
public abstract class AbstractInstanceMigrationEvent extends ApplicationEvent {

    protected final Job job;

    protected AbstractInstanceMigrationEvent(@Nonnull Object source, @Nonnull Job job) {
        super(source);
        this.job = job;
    }

    /**
     * @return Processing duration of the job since completion if {@link JobState#isTerminated()} returns {@code true}
     *         otherwise time elapsed since the job started
     */
    public long getDuration() {
        return job.getEndDate().map(d ->
                Duration.between(job.getStartDate(), d))
                .orElse(Duration.between(job.getStartDate(), Instant.now())).toMillis();
    }

    /**
     * @return return the {@link Job} that this event refers to
     */
    public long getJobId() {
        return job.getId();
    }
}