package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;

import javax.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

/**
 * @since 5.13
 */
public class RepositoriesExportRequest {

    private final Set<RepositorySelector> includes;

    private RepositoriesExportRequest(Builder builder) {
        includes = builder.includes.build();
    }

    @Nonnull
    public Set<RepositorySelector> getIncludes() {
        return includes;
    }

    public static final class Builder extends BuilderSupport {

        private final ImmutableSet.Builder<RepositorySelector> includes;

        public Builder() {
            includes = ImmutableSet.builder();
        }

        @Nonnull
        public RepositoriesExportRequest build() {
            return new RepositoriesExportRequest(this);
        }

        @Nonnull
        public Builder include(RepositorySelector value) {
            addIf(Objects::nonNull, includes, value);
            return this;
        }

        @Nonnull
        public Builder includes(Iterable<RepositorySelector> values) {
            addIf(Objects::nonNull, includes, values);
            return this;
        }
    }
}
