package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.validation.annotation.RequiredString;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Represents a request to import repositories from a file.
 *
 * @since 5.13
 */
public class ImportRequest {

    private final String archivePath;

    private ImportRequest(@Nonnull Builder builder) {
        archivePath = builder.archivePath;
    }

    @RequiredString
    public String getArchivePath() {
        return archivePath;
    }

    public static class Builder {

        private String archivePath;

        @Nonnull
        public ImportRequest build() {
            if (archivePath == null) {
                throw new IllegalStateException("archivePath is required");
            }

            return new ImportRequest(this);
        }

        @Nonnull
        public Builder archivePath(@Nonnull String value) {
            archivePath = requireNonNull(value, "value");
            return this;
        }
    }
}
