package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown when an operation cannot be routed to Mesh because all replicas of the target repository have been
 * marked inconsistent (and needing repair) or failed (for example, because the hosting node is offline).
 *
 * @since 8.0
 */
public class RepositoryInconsistentException extends IllegalRepositoryStateException {

    public RepositoryInconsistentException(@Nonnull KeyedMessage message) {
        this(message, null);
    }

    public RepositoryInconsistentException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
