package com.atlassian.bitbucket.mesh;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * A request to {@link MeshService#register register} a new {@link MeshNode}.
 *
 * @since 8.0
 */
public class RegisterMeshNodeRequest {

    private final String name;
    private final String rpcUrl;

    private RegisterMeshNodeRequest(Builder builder) {
        name = builder.name;
        rpcUrl = builder.rpcUrl;
    }

    /**
     * @return the optional human-readable name for the new node; if not specified the name is inferred from the URL
     */
    @Nullable
    public String getName() {
        return name;
    }

    /**
     * @return the RPC URL for the new node, with the scheme ({@code http://} or {@code https://}) indicating whether
     *         a secure connection should be used
     */
    @Nonnull
    public String getRpcUrl() {
        return rpcUrl;
    }

    public static class Builder {

        private String name;
        private String rpcUrl;

        @Nonnull
        public RegisterMeshNodeRequest build() {
            requireNonNull(rpcUrl, "rpcUrl");

            return new RegisterMeshNodeRequest(this);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            name = value;
            return this;
        }

        @Nonnull
        public Builder rpcUrl(@Nonnull String value) {
            rpcUrl = requireNonNull(value, "rpcUrl");
            return this;
        }
    }
}
