package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate a misconfiguration between Bitbucket Server and Mesh which prevents RPC requests from
 * being sent to the node.
 *
 * @since 8.0
 */
public class MeshNodeAuthenticationException extends MeshNodeConnectionException {

    public MeshNodeAuthenticationException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
