package com.atlassian.bitbucket.mail;

import javax.annotation.Nonnull;

public interface SoyMailBuilder {

    /**
     * Creates mail messages to the given recipients, using the supplied
     * context to render the soy template specified, then inlining the given
     * CSS with the given subject.
     *
     * @param message message containing message details to be sent
     * @return created mail messages
     */
    @Nonnull
    Iterable<MailMessage> build(@Nonnull SoyMailMessageRequest message);
}
