package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates an error occurred sending an email because one or more of the email addresses was rejected by the mail
 * server. Regarding logging of instances of this exception, see {@link MailException}.
 *
 * @since 4.14
 */
public class MailAddressInvalidException extends MailSendException {

    public MailAddressInvalidException(KeyedMessage message, Throwable cause) {
        super(message, cause);
    }
}
