package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Progress;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Optional;

/**
 * Represents a job that runs for some period of time doing some specific set of tasks on a single node in the cluster.
 *
 * @since 5.13
 */
public interface Job {

    /**
     * @return the job's ID
     */
    long getId();

    /**
     * @return the node the job is currently running on
     */
    @Nonnull
    String getNodeId();

    /**
     * @return a string representation of the type of this job. This is feature-specific and allows jobs to be
     * categorised when querying to filter out jobs unrelated to the feature doing the query.
     */
    @Nonnull
    String getType();

    /**
     * @return the user who initiated the job or empty for system-initiated jobs
     */
    @Nonnull
    Optional<ApplicationUser> getInitiator();

    /**
     * @return when the job was created and started
     */
    @Nonnull
    Instant getStartDate();

    /**
     * @return when the job details were last updated
     */
    @Nonnull
    Instant getUpdatedDate();

    /**
     * @return when the job was ended or empty if it has not started or is still running
     */
    @Nonnull
    Optional<Instant> getEndDate();

    /**
     * @return the progress of the job
     */
    @Nonnull
    Progress getProgress();

    /**
     * @return the current state of the job
     */
    @Nonnull
    JobState getState();

    /**
     * @return the current version of the job
     */
    int getVersion();
}
