package com.atlassian.bitbucket.io;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * A readable source of type {@code T}.
 * 
 * @since 4.13 
 */
@FunctionalInterface
public interface InputSupplier<T> {

    /**
     * Provides an object that encapsulates a readable resource. Each call to this method will produce a <i>new</i> object.
     *
     * @return object that encapsulates a readable resource.
     * @throws IOException in case the readable resource could not be opened or read
     */
    @Nonnull
    T open() throws IOException;
}
