package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown when a {@link HookScript hook script} can't be written to or read from the backing store.
 *
 * @since 6.2
 */
public class HookScriptStoreException extends HookScriptException {

    public HookScriptStoreException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public HookScriptStoreException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
