package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown when an app attempts to {@link HookScriptService#create create} or {@link HookScriptService#update update}
 * a {@link HookScript hook script} with contents which exceed the {@link HookScriptService#getMaxSize configured max
 * size}.
 *
 * @since 6.2
 */
public class HookScriptSizeExceededException extends HookScriptStoreException {

    private final int maxSize;
    private final int size;

    public HookScriptSizeExceededException(@Nonnull KeyedMessage message, int maxSize, int size) {
        super(message);

        this.maxSize = maxSize;
        this.size = size;
    }

    /**
     * @return the configured max size for hook script contents
     */
    public int getMaxSize() {
        return maxSize;
    }

    /**
     * @return the hook script contents' actual size
     */
    public int getSize() {
        return size;
    }
}
