package com.atlassian.bitbucket.hook.script;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import java.util.Set;

import static java.util.Objects.requireNonNull;

/**
 * Event fired when a new configuration is set for a {@link HookScript}.
 *
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 *
 * @since 6.2
 */
@AsynchronousPreferred
@EventName("stash.hook.script.configuration.set")
public class HookScriptConfigurationSetEvent extends HookScriptConfigurationEvent {

    private final Set<String> triggerIds;

    public HookScriptConfigurationSetEvent(@Nonnull Object source, @Nonnull HookScriptConfig config) {
        super(source, requireNonNull(config, "config").getScript(), config.getScope());
        this.triggerIds = config.getTriggerIds();
    }

    @Nonnull
    public Set<String> getTriggerIds() {
        return triggerIds;
    }
}
