package com.atlassian.bitbucket.hook.repository;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * Basic implementation of {@link RepositoryHookVeto}
 *
 * @since 5.0
 */
public class SimpleRepositoryHookVeto implements RepositoryHookVeto {

    private final String detailedMessage;
    private final String summaryMessage;

    public SimpleRepositoryHookVeto(@Nonnull String summaryMessage, @Nonnull String detailedMessage) {
        checkArgument(!requireNonNull(summaryMessage, "summaryMessage").trim().isEmpty(),
                "A non-blank summaryMessage is required");
        checkArgument(!requireNonNull(detailedMessage, "detailMessage").trim().isEmpty(),
                "A non-blank detailedMessage is required");

        this.detailedMessage = detailedMessage;
        this.summaryMessage = summaryMessage;
    }

    @Nonnull
    @Override
    public String getSummaryMessage() {
        return summaryMessage;
    }

    @Nonnull
    @Override
    public String getDetailedMessage() {
        return detailedMessage;
    }
}
